clear 
***read in data****

set more off
use "/home/cramer/lpd.dta"

*log using tom_maker.log, replace

drop if lfs==-1
keep if mdate>=tm(2001m10)

keep if age>24 & age<=55
keep if match == 1 | mis==5 | mis==1

gen months_dur = floor(udur/4.01) if !missing(udur) & udur>=0

gen zero_months_dur= (months_dur ==0)

gen six_months_dur = (months_dur==6)

gen seven_months_dur = (months_dur==7)

*bys pid (mis): gen udur_un = udur[_n-1] if lfs == 3 & lfs[_n-1] == 2 & lft==6 & mis == mis[_n-1] + 1 & mis != 5

bys pid (mis): gen months_dur_previous = months_dur[_n-1] if mis == mis[_n-1] + 1 & mis != 5 & !missing(months_dur[_n-1]) 




label define prev_unemp 0 "not unemployed" 1 "short-term unemplyoed" 2 "long-term unemployed"





*/

gen E = (lfs==1)
gen U = (lfs==2)
gen N = (lfs==3)


gen EE = (lft==0 | lft==1)
gen EU = (lft==2)
gen EN = (lft==3)
gen UE_short = (lft==4 & !missing(months_dur_previous) & months_dur_previous<=7) 
gen UE_long = (lft==4 & !missing(months_dur_previous) & months_dur_previous>7)
gen UU_short = (lft==5 & !missing(months_dur_previous) & months_dur_previous<=7)
gen UU_long = (lft==5 & !missing(months_dur_previous) & months_dur_previous>7)
gen UN_short = (lft==6 & !missing(months_dur_previous) & months_dur_previous<=7)
gen UN_long = (lft==6 & !missing(months_dur_previous) & months_dur_previous>7)
gen NE = (lft==7)
gen NU = (lft==8)
gen NN = (lft==9)

drop if mis==1 | mis==5 

gen round_weight = round(sswgt)

*collapse (sum) E U N EE EU EN UE UU UN NE NU NN dur*  [fweight = round_weight], by(mdate)

collapse (sum) E U N EE EU EN UE_* UU_* UN_* NE NU NN  [fweight = round_weight], by(mdate)

format mdate %tm

*foreach i in 0_5 6_14 15_26 27_52 53plus {
*gen transitionrate_UN_`i' =  dur`i'_to_n/dur`i'[_n-1]
*}
gen month = 1 if mdate== tm(2001m1) | mdate==tm(2002m1) | mdate==tm(2003m1) | mdate==tm(2004m1) | mdate==tm(2005m1) | mdate==tm(2006m1) | mdate==tm(2007m1) | mdate==tm(2008m1) | mdate==tm(2009m1)| mdate==tm(2010m1) | mdate==tm(2011m1) | mdate==tm(2012m1) | mdate==tm(2013m1)

forvalues i = 2/12 {
replace month = `i' if mdate== tm(2001m`i') | mdate== tm(2002m`i') | mdate==tm(2003m`i') | mdate==tm(2004m`i') | mdate==tm(2005m`i') | mdate==tm(2006m`i') | mdate==tm(2007m`i') | mdate==tm(2008m`i') | mdate==tm(2009m`i')| mdate==tm(2010m`i') | mdate==tm(2011m`i') | mdate==tm(2012m`i') | mdate==tm(2013m`i')
}

tab month, gen(S_adj)

constraint 1 S_adj1 + S_adj1 + S_adj1 + S_adj2 + S_adj3 + S_adj4 + S_adj5 + S_adj6 + S_adj7 + S_adj8 + S_adj9 + S_adj10 + S_adj11 + S_adj12 = 0

foreach var of varlist E- seven_ {
gen `var'_resids = 0
}


foreach var of varlist E- seven_months_dur  {
quietly cnsreg `var' S_adj*, constraints(1)
replace `var'_resids = `var' - _b[S_adj1] if month==1
replace `var'_resids = `var' - _b[S_adj2] if month==2
replace `var'_resids = `var' - _b[S_adj3] if month==3
replace `var'_resids = `var' - _b[S_adj4] if month==4
replace `var'_resids = `var' - _b[S_adj5] if month==5
replace `var'_resids = `var' - _b[S_adj6] if month==6
replace `var'_resids = `var' - _b[S_adj7] if month==7
replace `var'_resids = `var' - _b[S_adj8] if month==8
replace `var'_resids = `var' - _b[S_adj9] if month==9
replace `var'_resids = `var' - _b[S_adj10] if month==10
replace `var'_resids = `var' - _b[S_adj11] if month==11
replace `var'_resids = `var' - _b[S_adj12] if month==12
}


foreach state in EE_resids EU_resids EN_resids {
gen transition_rate_`state' = `state'/ (EE_resids + EU_resids + EN_resids)
}

foreach state in UE_short_resids UU_short_resids UN_short_resids {
gen transition_rate_`state' = `state'/ (UE_short_resids + UU_short_resids + UN_short_resids)
}

foreach state in UE_long_resids UU_long_resids UN_long_resids {
gen transition_rate_`state' = `state'/ (UE_long_resids + UU_long_resids + UN_long_resids)
}

foreach state in NE_resids NU_resids NN_resids {
gen transition_rate_`state' = `state'/ (NE_resids + NU_resids + NN_resids)
}

gen psi_n = transition_rate_NU_resids / transition_rate_NE_resids

gen psi_e = transition_rate_EN_resids / transition_rate_EU_resids

gen psi_u_short = transition_rate_UN_short_resids / transition_rate_UE_short_resids

gen psi_u_long = transition_rate_UN_long_resids / transition_rate_UE_long_resids




foreach var of varlist psi_n-psi_u_long {
gen `var'_resids = 0
}


foreach var of varlist psi_n-psi_u_long {
quietly cnsreg `var' S_adj*, constraints(1)
replace `var'_resids = `var' - _b[S_adj1] if month==1
replace `var'_resids = `var' - _b[S_adj2] if month==2
replace `var'_resids = `var' - _b[S_adj3] if month==3
replace `var'_resids = `var' - _b[S_adj4] if month==4
replace `var'_resids = `var' - _b[S_adj5] if month==5
replace `var'_resids = `var' - _b[S_adj6] if month==6
replace `var'_resids = `var' - _b[S_adj7] if month==7
replace `var'_resids = `var' - _b[S_adj8] if month==8
replace `var'_resids = `var' - _b[S_adj9] if month==9
replace `var'_resids = `var' - _b[S_adj10] if month==10
replace `var'_resids = `var' - _b[S_adj11] if month==11
replace `var'_resids = `var' - _b[S_adj12] if month==12
}


